/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ModeloValoresClienteExportacion
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc = new DataCatalogos();
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacionCliente = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paises = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> clasesDeContribuyente = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarPaises();
            this.cargarTiposIdentificacion();
            this.cargarClasesDeContribuyente();
            this.inicializado = true;
        }
    }

    private void cargarClasesDeContribuyente() {
        this.clasesDeContribuyente.clear();
        Map tiposConsultados = UtilCatalogosATS.crearInstancia().obtenerTiposDeContribuyente();
        for (Map.Entry tipoContribuyente : tiposConsultados.entrySet()) {
            this.clasesDeContribuyente.put((String)tipoContribuyente.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoContribuyente.getValue(), (Object)((String)tipoContribuyente.getKey())));
        }
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacionCliente.clear();
        this.tiposIdentificacionCliente.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacionCliente.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacionCliente() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacionCliente.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacionCliente.get(tipoIdentificacion);
    }

    public List<ElementoNombreValor<String>> getClasesDeContribuyente() {
        return new ArrayList<ElementoNombreValor<String>>(this.clasesDeContribuyente.values());
    }

    public ElementoNombreValor<String> obtenerClaseDeContribuyente(String tipoProveedor) {
        return StringUtil.isNullOrEmpty((String)tipoProveedor) ? null : this.clasesDeContribuyente.get(tipoProveedor);
    }

    public List<ElementoNombreValor<String>> getPaises() {
        return new ArrayList<ElementoNombreValor<String>>(paises.values());
    }

    private void cargarPaises() {
        paises.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = this.dc.obtenerPaises();
        for (Map.Entry entry : cPaises.entrySet()) {
            if ("593".equals(entry.getKey())) continue;
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            paises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    private Comparator<ElementoNombreValor<String>> getComparadorElementoNombreValor() {
        return new Comparator<ElementoNombreValor<String>>(){

            @Override
            public int compare(ElementoNombreValor<String> e1, ElementoNombreValor<String> e2) {
                return e1.getEtiqueta().compareTo(e2.getEtiqueta());
            }
        };
    }

    public ElementoNombreValor<String> obtenerPais(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paises.get(pais);
    }
}

